#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <ctime>
#include <cctype>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <set>
#include <algorithm>
#include <map>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef long long unsigned ull;
typedef unsigned uint;

template <class T> inline T sqr(T x) { return x * x; }
template <class T> inline void updMin(T& a, const T& b) { if (b < a) a = b; }
template <class T> inline void updMax(T& a, const T& b) { if (b > a) a = b; }

const int maxn = 2000 + 100;
const int maxm = 100000 * 3 + 100;

int boyStart[maxn];
int girlStart[maxn];
int boyNext[maxm];
int girlNext[maxm];

int boyTo[maxm];
int girlTo[maxm];

int eSize = 0;

int frG[maxn];
int frB[maxn];

bool d[maxn][maxn];
bool dyn[maxn];
int start;
int finish;
bool vis[maxn];

bool dfs(int v)
{
	/*if (v == finish)
		return true;*/

	vis[v] = true;
	for (int j = boyStart[v]; j != -1; j = boyNext[j])
	{
		int girl = boyTo[j];

		if (girl == frB[v])
			continue;

		if (girl == finish)
			return true;


		int boy = frG[girl];
		if (!vis[boy])
			dyn[boy] = dfs(boy);
		
		if (dyn[boy])
			return true;
	}
	return false;
}

int main()
{
	//freopen("input.txt", "r", stdin); freopen("output.txt", "w", stdout);

	int n;
	scanf("%d", &n);
	
	memset(boyStart, -1, sizeof(boyStart));
	memset(girlStart, -1, sizeof(girlStart));

	for (int i = 0; i < n; ++i)
	{
		int k;
		scanf("%d", &k);
		for (int j = 0; j < k; ++j)
		{
			int to;
			scanf("%d", &to);
			--to;

			boyNext[eSize] = boyStart[i];
			boyStart[i] = eSize;
			boyTo[eSize] = to;

			girlNext[eSize] = girlStart[to];
			girlStart[to] = eSize;
			girlTo[eSize] = i;

			++eSize;
		}
	}

	
	for (int i = 0; i < n; ++i)
	{
		int girl;
		scanf("%d", &girl);
		--girl;
		frB[i] = girl;
		frG[girl] = i;
	}

	for (int i = 0; i < n; ++i)
	{
		start = i;
		finish = frB[i];
		d[i][finish] = true;
		memset(vis, false, sizeof(vis));
		memset(dyn, false, sizeof(dyn));
		vis[i] = true;
		for (int j = boyStart[i]; j != -1; j = boyNext[j])
		{
			int to = boyTo[j];
			if (to != finish) {
				if (!vis[frG[to]]) {
					dyn[frG[to]] = dfs(frG[to]);
				}
				d[i][to] = dyn[frG[to]];
			}
		}
	}

	

	for (int i = 0; i < n; ++i)
	{
		int l = 0;
		for (int j = 0; j < n; ++j)
			l += int(d[i][j]);
		printf("%d ", l);
		for (int j = boyStart[i]; j != -1; j = boyNext[j])
		{
			int girl = boyTo[j];
			if (d[i][girl])
				printf("%d ", girl + 1);
		}
		puts("");
	}

	return 0;
}